/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.sfp.srvutil;

import com.ibm.hsc.auiml.databeans.sfp.srvutil.NetworkTopologyBean;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.sfp.topology.NetworkTopology;
import com.ibm.hsc.sfp.topology.NetworkTopologyConstants;
import com.ibm.hsc.sfp.topology.NetworkTopologyEvent;
import com.ibm.hsc.sfp.topology.NetworkTopologyListener;
import com.ibm.hsc.sfp.topology.NetworkTopologyNode;
import com.ibm.hsc.sfp.topology.PingNotSupportedException;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.target.TargetedTasklet;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressEndEvent;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.task.ProgressUpdateEvent;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;

public class NetworkTopologyTasklet
extends TargetedTasklet
implements NetworkTopologyConstants,
NetworkTopologyListener {
    private static final String TRACE_MASKT = "JNETTOPT";
    private static final String TRACE_MASKF = "JNETTOPF";
    private static final String TRACE_MASKD = "JNETTOPD";
    private static ClassLogInfo _logInfo = new ClassLogInfo(-88, -128, "SFPUtilNetT");
    static final short ERRID_0101 = 257;
    private static final String PROGRESS_ID = "NetworkTopologyProgress";
    private NetworkTopology currentTopology = null;
    private NetworkTopology savedTopology = null;
    private LocalizableText cumulativeMsg = null;

    public NetworkTopologyTasklet() {
        Trace.trace((String)TRACE_MASKT, (Object)"<->NetworkTopologyTasklet - ctor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)"->NetworkTopologyTasklet.service()");
        try {
            NetworkTopologyNode networkTopologyNode;
            this.showBusyDialog(new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "SERVICE_FOCAL_POINT"), new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "GENERIC_BUSY"));
            String string = (String)panelTaskletRequest.getData("TopoButtonName");
            if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
                panelTaskletResponse.dispose();
            } else if (panelTaskletRequest.isInitialRequest()) {
                this.discoverTopology();
                this.savedTopology = NetworkTopology.getSavedTopology();
                NetworkTopologyBean networkTopologyBean = new NetworkTopologyBean(this.currentTopology, this.savedTopology);
                panelTaskletResponse.replace("com.ibm.hsc.auiml.databeans.sfp.srvutil.NetworkTopology", "NetworkTopologyPanel", (PanelBean)networkTopologyBean);
            } else if ("SaveButton".equals(string)) {
                try {
                    NetworkTopology.saveTopology(this.currentTopology);
                    this.savedTopology = NetworkTopology.getSavedTopology();
                    NetworkTopologyBean networkTopologyBean = new NetworkTopologyBean(this.currentTopology, this.savedTopology);
                    panelTaskletResponse.replace("com.ibm.hsc.auiml.databeans.sfp.srvutil.NetworkTopology", "NetworkTopologyPanel", (PanelBean)networkTopologyBean);
                }
                catch (IOException iOException) {
                    MessageText messageText = new MessageText("com.ibm.hsc.common.bundles.SFPResourceBundleMessages", "0002", null, MsgType.ERROR_MESSAGE, "HSCS0002");
                    this.showMessageBox(true, new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "SFP_MESSAGE_ERROR_TITLE"), new MessageText[]{messageText}, null, null, null);
                }
            } else if ("RefreshButton".equals(string)) {
                this.discoverTopology();
                this.savedTopology = NetworkTopology.getSavedTopology();
                NetworkTopologyBean networkTopologyBean = new NetworkTopologyBean(this.currentTopology, this.savedTopology);
                panelTaskletResponse.replace("com.ibm.hsc.auiml.databeans.sfp.srvutil.NetworkTopology", "NetworkTopologyPanel", (PanelBean)networkTopologyBean);
            } else if (("Button1".equals(string) || "Button2".equals(string)) && (networkTopologyNode = (NetworkTopologyNode)panelTaskletRequest.getData("TopoNode")).supportsPing()) {
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    networkTopologyNode.ping(10, 5, stringBuffer);
                    String[] stringArray = new String[]{stringBuffer.toString(), "Button1".equals(string) ? "CurrentTopologyString" : "SavedTopologyString"};
                    panelTaskletResponse.update((Object)stringArray);
                }
                catch (PingNotSupportedException pingNotSupportedException) {
                }
            }
            Object var8_13 = null;
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            try {
                this.destroyBusyDialog();
            }
            catch (TaskletException taskletException) {
                // empty catch block
            }
            if (!panelTaskletResponse.isResponseSet()) {
                panelTaskletResponse.noAction();
            }
            throw throwable;
        }
        try {
            this.destroyBusyDialog();
        }
        catch (TaskletException taskletException) {
            // empty catch block
        }
        if (!panelTaskletResponse.isResponseSet()) {
            panelTaskletResponse.noAction();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<-NetworkTopologyTasklet.service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopologyTasklet.logException()");
        HException hException = new HException(throwable);
        new AusMicrocodeLog(_logInfo, 257, hException).log();
        Trace.trace((String)TRACE_MASKT, (Object)"<- NetworkTopologyTasklet.logException()");
    }

    private void discoverTopology() {
        boolean bl = false;
        try {
            this.cumulativeMsg = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "TOPOLOGY_STARTED");
            this.startProgress(new ProgressStartEvent(new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "TOPOLOGY_HEADING"), new ProgressData[]{new ProgressData((ObjectId)null)}, 0L, this.cumulativeMsg, PROGRESS_ID));
            bl = true;
        }
        catch (TaskletException taskletException) {
            this.logException(taskletException);
        }
        this.currentTopology = NetworkTopology.getCurrentTopology(this);
        if (bl) {
            try {
                ProgressEndEvent progressEndEvent = new ProgressEndEvent(PROGRESS_ID);
                progressEndEvent.setAutoDismissal(3);
                this.endProgress(progressEndEvent);
            }
            catch (TaskletException taskletException) {
                this.logException(taskletException);
            }
        }
    }

    public void topologyChanged(NetworkTopologyEvent networkTopologyEvent) {
        int n = networkTopologyEvent.getEventId();
        LocalizableText localizableText = null;
        switch (n) {
            case 1: {
                localizableText = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "TOPOLOGY_CREATED_LOCAL_HMC");
                break;
            }
            case 2: {
                localizableText = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "TOPOLOGY_CREATED_ETHERNET_PORTS");
                break;
            }
            case 3: {
                localizableText = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "TOPOLOGY_CREATED_FACILITIES");
                break;
            }
            case 4: {
                localizableText = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "TOPOLOGY_CREATED_MANAGED_SYSTEMS");
                break;
            }
            case 5: {
                localizableText = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "TOPOLOGY_CREATED_LPARS");
                break;
            }
            case 6: {
                localizableText = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "TOPOLOGY_CREATED_REMOTE_HMCS");
                break;
            }
            case 10: {
                localizableText = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "TOPOLOGY_TREE_STRUCTURE_COMPLETE");
                break;
            }
            case 20: {
                localizableText = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "TOPOLOGY_COMPLETE");
                break;
            }
        }
        if (localizableText != null) {
            this.cumulativeMsg = this.cumulativeMsg == null ? localizableText : new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "TOPOLOGY_JOIN_TWO_MESSAGES", new Object[]{this.cumulativeMsg, localizableText});
            try {
                this.updateProgress(new ProgressUpdateEvent(new ProgressData(this.cumulativeMsg), PROGRESS_ID));
            }
            catch (TaskletException taskletException) {
                this.logException(taskletException);
            }
        }
    }
}

